/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import galena.oreganized.Oreganized;
import galena.oreganized.index.OFeatures;
import galena.oreganized.index.OTags;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class OBiomeModifier {
    private static final RegistryAccess access = RegistryAccess.m_206197_();
    private static final Registry<Biome> biomeRegistry = access.m_175515_(Registry.f_122885_);
    private static final Registry<PlacedFeature> placedFeatures = access.m_175515_(Registry.f_194567_);
    private static final HashMap<ResourceLocation, BiomeModifier> modifiers = new HashMap();

    public static JsonCodecProvider<BiomeModifier> register(GatherDataEvent event) {
        OBiomeModifier.addFeatures();
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)event.getGenerator(), (ExistingFileHelper)event.getExistingFileHelper(), (String)"oreganized", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)access), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, modifiers);
    }

    private static void addFeatures() {
        OBiomeModifier.addFeature("silver_ore", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, OFeatures.Placed.SILVER_ORE_LOW);
        OBiomeModifier.addFeature("silver_ore_high", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, OFeatures.Placed.SILVER_ORE_HIGH);
        OBiomeModifier.addFeature("lead_ore", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.UNDERGROUND_ORES, OFeatures.Placed.LEAD_ORE);
        OBiomeModifier.addFeature("lead_ore_extra", OTags.Biomes.RICH_IN_LEAD_ORE, GenerationStep.Decoration.UNDERGROUND_ORES, OFeatures.Placed.LEAD_ORE_EXTRA);
    }

    @SafeVarargs
    private static void addFeature(String name, TagKey<Biome> tagKey, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        modifiers.put(Oreganized.modLoc("features/" + name), (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named(biomeRegistry, tagKey), OBiomeModifier.featureSet(features), step));
    }

    private static void removeFeature(String name, TagKey<Biome> tagKey, GenerationStep.Decoration step, Holder<PlacedFeature> feature) {
        modifiers.put(Oreganized.modLoc("features/" + name), (BiomeModifier)new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)new HolderSet.Named(biomeRegistry, tagKey), OBiomeModifier.featureSet(feature), Set.of(step)));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> placedFeatures.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(Holder<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(holder -> placedFeatures.m_214121_((ResourceKey)holder.m_203543_().get())).collect(Collectors.toList()));
    }
}

