/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data.provider;

import galena.oreganized.Oreganized;
import galena.oreganized.content.block.CrystalGlassBlock;
import galena.oreganized.content.block.CrystalGlassPaneBlock;
import galena.oreganized.content.block.ExposerBlock;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class OBlockStateProvider
extends BlockStateProvider {
    public OBlockStateProvider(DataGenerator gen, ExistingFileHelper help) {
        super(gen, "oreganized", help);
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    protected String name(Supplier<? extends Block> block) {
        return this.name(block.get());
    }

    private String suffixByIndex(int index) {
        switch (index) {
            case 1: {
                return "_rot";
            }
            case 2: {
                return "_in";
            }
            case 3: {
                return "_out";
            }
        }
        return "";
    }

    public void simpleBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    public void stairsBlock(Supplier<? extends StairBlock> block, Supplier<? extends Block> fullBlock) {
        this.stairsBlock(block.get(), this.texture(this.name(fullBlock)));
    }

    public void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> fullBlock) {
        this.slabBlock(block.get(), this.texture(this.name(fullBlock)), this.texture(this.name(fullBlock)));
    }

    public void wallBlock(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        this.wallBlock(wall.get(), this.texture(this.name(fullBlock)));
    }

    public void waxedBlock(Supplier<? extends Block> block, Block origin) {
        this.simpleBlock(block.get(), this.cubeAll(origin));
    }

    public ModelFile cubeBottomTop(Supplier<? extends Block> block) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(this.name(block));
        model.parent((ModelFile)this.models().getExistingFile(new ResourceLocation("minecraft", "block/cube_bottom_top")));
        model.texture("top", this.texture(this.name(block) + "_top"));
        model.texture("bottom", this.texture(this.name(block) + "_bottom"));
        model.texture("side", this.texture(this.name(block) + "_side"));
        return model;
    }

    public ModelFile directionalBlockModel(Supplier<? extends Block> block, String name, String side, String front, String back, String top) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/observer")).texture("bottom", this.texture(back))).texture("side", this.texture(side))).texture("top", this.texture(top))).texture("front", this.texture(front))).texture("particle", this.texture(front));
    }

    public void exposer(Supplier<? extends Block> block) {
        this.getVariantBuilder(block.get()).forAllStates(state -> {
            int level = Math.round(3.0f / (float)((Integer)state.m_61143_((Property)ExposerBlock.LEVEL) + 1));
            Direction facing = (Direction)state.m_61143_((Property)ExposerBlock.f_52588_);
            int x = 0;
            int y = 0;
            if (facing == Direction.EAST) {
                y = 90;
            }
            if (facing == Direction.SOUTH) {
                y = 180;
            }
            if (facing == Direction.WEST) {
                y = 270;
            }
            if (facing == Direction.DOWN) {
                x = 90;
            }
            if (facing == Direction.UP) {
                x = 270;
            }
            String name = this.name(block) + "_level_" + level;
            String side = this.name(block) + "_side";
            String back = (Integer)state.m_61143_((Property)ExposerBlock.LEVEL) > 0 ? this.name(block) + "_back_on" : this.name(block) + "_back";
            String top = this.name(block) + "_top";
            return ConfiguredModel.builder().modelFile(this.directionalBlockModel(block, name + "_" + facing, side, name, back, top)).rotationX(x).rotationY(y).build();
        });
    }

    public ModelFile cauldronModel(Supplier<? extends Block> block, ResourceLocation texture, int age) {
        String name = this.name(block) + age;
        return ((BlockModelBuilder)this.models().withExistingParent(name, "block/template_cauldron_full")).texture("content", texture);
    }

    public ModelFile cauldronModel(Supplier<? extends Block> cauldron, Supplier<? extends Block> content, int age) {
        return this.cauldronModel(cauldron, this.texture(this.name(content)), age);
    }

    public void moltenCauldron(Supplier<? extends Block> cauldron, Supplier<? extends Block> content) {
        this.getVariantBuilder(cauldron.get()).forAllStates(state -> {
            int age = (Integer)state.m_61143_((Property)MoltenLeadCauldronBlock.AGE);
            if (age == 0) {
                return ConfiguredModel.builder().modelFile(this.cauldronModel(cauldron, content, age)).build();
            }
            ResourceLocation texture = age == 3 ? this.texture("molten_" + this.name(content)) : this.texture(this.name(content) + "2");
            return ConfiguredModel.builder().modelFile(this.cauldronModel(cauldron, texture, age)).build();
        });
    }

    public void crystalGlassBlock(Supplier<? extends Block> block) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block.get()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(0)).modelForState().modelFile(this.cubeAll(block.get())).addModel()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_rot", Oreganized.modLoc("block/" + this.name(block) + "_rot"))).addModel()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_in", Oreganized.modLoc("block/" + this.name(block) + "_in"))).addModel()).partialState().with((Property)CrystalGlassBlock.TYPE, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)this.models().cubeAll(this.name(block) + "_out", Oreganized.modLoc("block/" + this.name(block) + "_out"))).addModel();
    }

    public void crystalGlassPaneBlock(Supplier<? extends Block> pane, Supplier<? extends Block> fullBlock) {
        String baseName = this.name(fullBlock);
        String paneName = this.name(pane);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(pane.get());
        int i = 0;
        while (i < 4) {
            int finalI = i++;
            PipeBlock.f_55154_.entrySet().forEach(e -> {
                Direction dir = (Direction)e.getKey();
                if (dir.m_122434_().m_122479_()) {
                    boolean alt = dir == Direction.SOUTH;
                    ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)this.models().panePost(paneName + "_post" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI)), Oreganized.modLoc("block/" + paneName + "_top"))).addModel()).condition((Property)CrystalGlassPaneBlock.TYPE, (Comparable[])new Integer[]{finalI}).end().part().modelFile((ModelFile)(alt || dir == Direction.WEST ? this.models().paneSideAlt(paneName + "_side_alt" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI)), Oreganized.modLoc("block/" + paneName + "_top")) : this.models().paneSide(paneName + "_side" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI)), Oreganized.modLoc("block/" + paneName + "_top")))).rotationY(dir.m_122434_() == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{true}).condition((Property)CrystalGlassPaneBlock.TYPE, (Comparable[])new Integer[]{finalI}).end().part().modelFile((ModelFile)(alt || dir == Direction.EAST ? this.models().paneNoSideAlt(paneName + "_noside_alt" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI))) : this.models().paneNoSide(paneName + "_noside" + this.suffixByIndex(finalI), Oreganized.modLoc("block/" + baseName + this.suffixByIndex(finalI))))).rotationY(dir == Direction.WEST ? 270 : (dir == Direction.SOUTH ? 90 : 0)).addModel()).condition((Property)e.getValue(), (Comparable[])new Boolean[]{false}).condition((Property)CrystalGlassPaneBlock.TYPE, (Comparable[])new Integer[]{finalI});
                }
            });
        }
    }

    public ModelFile engravedFace(Block block, Boolean engraved) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(this.name(block));
        ResourceLocation textureLoc = engraved != false ? this.texture("engraved/" + this.name(block)) : this.texture(this.name(block));
        model.parent((ModelFile)this.models().getExistingFile(new ResourceLocation("minecraft", "block/template_single_face")));
        model.texture("texture", textureLoc);
        return model;
    }
}

