/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;

public class BananaFrondBlock
extends BushBlock
implements BonemealableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty MOIST = BooleanProperty.m_61465_((String)"moist");
    private static final Map<Direction, VoxelShape> SMALL_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)4.0, (double)7.0, (double)8.0, (double)12.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)4.0, (double)7.0, (double)0.0, (double)12.0, (double)15.0, (double)8.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)8.0, (double)7.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)7.0, (double)4.0, (double)8.0, (double)15.0, (double)12.0), (Object)Direction.UP, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)4.0, (double)13.0), (Object)Direction.DOWN, (Object)Block.m_49796_((double)3.0, (double)12.0, (double)2.0, (double)13.0, (double)16.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)5.0, (double)6.0, (double)13.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)15.0, (double)10.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)6.0, (double)5.0, (double)3.0, (double)16.0, (double)15.0, (double)13.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)5.0, (double)3.0, (double)10.0, (double)15.0, (double)13.0), (Object)Direction.UP, (Object)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.5, (double)14.0), (Object)Direction.DOWN, (Object)Block.m_49796_((double)2.0, (double)11.5, (double)2.0, (double)14.0, (double)16.0, (double)14.0)));
    private static final Map<Direction, VoxelShape> LARGE_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)4.0, (double)14.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)15.0, (double)12.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)4.0, (double)3.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)12.0, (double)15.0, (double)14.0), (Object)Direction.UP, (Object)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), (Object)Direction.DOWN, (Object)Block.m_49796_((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)));

    public BananaFrondBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)MOIST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(facing.m_122424_());
        BlockState blockState = level.m_8055_(blockpos);
        return BananaFrondBlock.m_49863_((LevelReader)level, (BlockPos)blockpos, (Direction)facing) || this.m_6266_(blockState, (BlockGetter)level, blockpos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (BananaFrondBlock.isLarge(state) ? LARGE_AABBS : (BananaFrondBlock.isSmall(state) ? SMALL_AABBS : AABBS)).get(state.m_61143_((Property)FACING));
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(BlockTags.f_13035_);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, MOIST});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Direction direction = context.m_43719_();
        if (BananaFrondBlock.isSmall(state)) {
            return BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).m_49966_());
        }
        if (state.m_60713_((Block)NeapolitanBlocks.BANANA_FROND.get())) {
            return BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_());
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)MOIST, (Comparable)Boolean.valueOf(direction == Direction.UP && BananaFrondBlock.canGrowOn(level.m_8055_(pos.m_7495_())) && BananaFrondBlock.canRainAt(level, pos)));
    }

    public static boolean canRainAt(Level level, BlockPos pos) {
        if (!level.m_45527_(pos)) {
            return false;
        }
        if (level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return false;
        }
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        return biome.m_47530_() == Biome.Precipitation.RAIN && biome.m_198906_(pos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_150930_((Item)NeapolitanItems.BANANA_FROND.get()) && !BananaFrondBlock.isLarge(state) || super.m_6864_(state, useContext);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NeapolitanItems.BANANA_FROND.get());
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        if (BananaFrondBlock.isLarge(state)) {
            return state.m_61143_((Property)FACING) == Direction.UP && level instanceof Level && ((Level)level).m_46758_(pos);
        }
        return true;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        if (BananaFrondBlock.isLarge(state) && rand.m_188503_(6) == 0) {
            BananaFrondBlock.attemptGrowBanana(BananaFrondBlock.getSizeForFrond(rand, (Block)this), (Level)level, rand, pos);
        } else if (BananaFrondBlock.isSmall(state)) {
            level.m_46597_(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).m_49966_()));
        } else {
            level.m_46597_(pos, BlockUtil.transferAllBlockStates((BlockState)state, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_()));
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)MOIST)).booleanValue() && level.m_46758_(pos) && BananaFrondBlock.canGrowOn(level.m_8055_(pos.m_7495_())) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.m_188503_(2) == 0 ? 1 : 0) != 0)) {
            BananaFrondBlock.attemptGrowBanana(BananaFrondBlock.getSizeForFrond(rand, (Block)this), (Level)level, rand, pos);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static boolean attemptGrowBanana(int size, Level level, RandomSource rand, BlockPos pos) {
        int i;
        BlockPos blockPos = pos;
        ArrayList<BlockPos> stalks = new ArrayList<BlockPos>();
        BlockPos bundle = null;
        HashMap<BlockPos, Direction> smallFronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> fronds = new HashMap<BlockPos, Direction>();
        HashMap<BlockPos, Direction> largeFronds = new HashMap<BlockPos, Direction>();
        for (i = 0; i < size; ++i) {
            stalks.add(blockPos);
            blockPos = blockPos.m_7494_();
        }
        BlockPos upFrond = blockPos;
        i = 0;
        for (BlockPos stalk : stalks) {
            if (i >= size - 3) {
                for (Direction direction : Direction.values()) {
                    if (!direction.m_122434_().m_122479_()) continue;
                    if (i == size - 1) {
                        if (rand.m_188503_(4) != 0) {
                            largeFronds.put(stalk.m_121945_(direction), direction);
                            continue;
                        }
                        fronds.put(stalk.m_121945_(direction), direction);
                        continue;
                    }
                    if (i == size - 2) {
                        if (rand.m_188499_()) {
                            fronds.put(stalk.m_121945_(direction), direction);
                            continue;
                        }
                        if (rand.m_188499_() && bundle == null) {
                            bundle = stalk.m_121945_(direction);
                            continue;
                        }
                        smallFronds.put(stalk.m_121945_(direction), direction);
                        continue;
                    }
                    if (i != size - 3 || rand.m_188503_(3) == 0) continue;
                    smallFronds.put(stalk.m_121945_(direction), direction);
                }
            }
            ++i;
        }
        if (BananaFrondBlock.isAirAt(level, pos, size) && pos.m_123342_() < level.m_151558_() - size) {
            for (BlockPos blockPos2 : stalks) {
                level.m_7731_(blockPos2, ((Block)NeapolitanBlocks.BANANA_STALK.get()).m_49966_(), 2);
            }
            level.m_7731_(upFrond, ((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_(), 2);
            if (bundle != null) {
                level.m_7731_(bundle, ((Block)NeapolitanBlocks.BANANA_BUNDLE.get()).m_49966_(), 2);
            }
            for (BlockPos blockPos2 : smallFronds.keySet()) {
                level.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.SMALL_BANANA_FROND.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)smallFronds.get(blockPos2))), 2);
            }
            for (BlockPos blockPos2 : fronds.keySet()) {
                level.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.BANANA_FROND.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)fronds.get(blockPos2))), 2);
            }
            for (BlockPos blockPos2 : largeFronds.keySet()) {
                level.m_7731_(blockPos2, (BlockState)((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)largeFronds.get(blockPos2))), 2);
            }
            return true;
        }
        return false;
    }

    public static boolean canGrowOn(BlockState state) {
        return state.m_204336_(Tags.Blocks.GRAVEL) || state.m_204336_(Tags.Blocks.SAND);
    }

    private static boolean isAirAt(Level level, BlockPos pos, int size) {
        for (int i = 0; i < size + 1; ++i) {
            if (i != 0 && !level.m_46859_(pos) && !level.m_8055_(pos).m_60767_().m_76336_()) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                if (!direction.m_122434_().m_122479_() || level.m_46859_(pos.m_121945_(direction)) || level.m_8055_(pos.m_121945_(direction)).m_60767_().m_76336_()) continue;
                return false;
            }
            pos = pos.m_7494_();
        }
        return true;
    }

    public static boolean isLarge(BlockState state) {
        return state.m_60713_((Block)NeapolitanBlocks.LARGE_BANANA_FROND.get());
    }

    public static boolean isSmall(BlockState state) {
        return state.m_60713_((Block)NeapolitanBlocks.SMALL_BANANA_FROND.get());
    }

    private static int getSizeForFrond(RandomSource rand, Block frond) {
        int extra = 0;
        if (frond == NeapolitanBlocks.SMALL_BANANA_FROND.get()) {
            extra = rand.m_188503_(2);
        }
        if (frond == NeapolitanBlocks.BANANA_FROND.get()) {
            extra = 1 + rand.m_188503_(2);
        }
        if (frond == NeapolitanBlocks.LARGE_BANANA_FROND.get()) {
            extra = 1 + rand.m_188503_(3);
        }
        return 3 + extra;
    }
}

