/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.entity.goal;

import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ChimpTemptBananaGoal
extends Goal {
    private static final TargetingConditions ENTITY_PREDICATE = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    protected final Chimpanzee chimpanzee;
    private final double speed;
    protected Player closestPlayer;
    private int delayTemptCounter;
    private int forgetTimer;
    private int patience;
    private double playerDistance;

    public ChimpTemptBananaGoal(Chimpanzee chimpanzeeIn, double speedIn) {
        this.chimpanzee = chimpanzeeIn;
        this.speed = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        if (!this.chimpanzee.needsSnack()) {
            return false;
        }
        this.closestPlayer = this.chimpanzee.f_19853_.m_45946_(ENTITY_PREDICATE, (LivingEntity)this.chimpanzee);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.m_21205_()) || this.isTempting(this.closestPlayer.m_21206_());
    }

    protected boolean isTempting(ItemStack stack) {
        return this.chimpanzee.isSnack(stack);
    }

    public boolean m_8045_() {
        if (this.forgetTimer <= 0) {
            return false;
        }
        if (this.closestPlayer == null || !ENTITY_PREDICATE.m_26885_((LivingEntity)this.chimpanzee, (LivingEntity)this.closestPlayer)) {
            return false;
        }
        return this.chimpanzee.needsSnack() && ENTITY_PREDICATE.m_26885_((LivingEntity)this.chimpanzee, (LivingEntity)this.closestPlayer);
    }

    public void m_8056_() {
        this.forgetTimer = this.m_183277_(100);
        this.patience = this.m_183277_(100);
        this.playerDistance = this.chimpanzee.m_20280_((Entity)this.closestPlayer);
    }

    public void m_8041_() {
        this.closestPlayer = null;
        this.chimpanzee.m_21573_().m_26573_();
        this.delayTemptCounter = this.m_183277_(100);
    }

    public void m_8037_() {
        this.chimpanzee.m_21563_().m_24960_((Entity)this.closestPlayer, (float)(this.chimpanzee.m_8085_() + 20), (float)this.chimpanzee.m_8132_());
        if (this.chimpanzee.m_20280_((Entity)this.closestPlayer) < 6.25) {
            this.chimpanzee.m_21573_().m_26573_();
        } else {
            this.chimpanzee.m_21573_().m_5624_((Entity)this.closestPlayer, this.speed);
        }
        double d0 = this.chimpanzee.m_20280_((Entity)this.closestPlayer);
        if (this.playerDistance < d0 && this.closestPlayer.m_20184_() != Vec3.f_82478_) {
            --this.patience;
        }
        this.playerDistance = d0;
        if (!this.chimpanzee.m_6162_() && this.patience <= 0 && !this.closestPlayer.m_150110_().f_35937_) {
            this.chimpanzee.m_6710_((LivingEntity)this.closestPlayer);
        }
        this.forgetTimer = !this.isTempting(this.closestPlayer.m_21205_()) && !this.isTempting(this.closestPlayer.m_21206_()) ? --this.forgetTimer : this.m_183277_(200);
        System.out.println(this.patience);
    }
}

