/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeapolitanConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> milkCauldron;
        public final ForgeConfigSpec.ConfigValue<Boolean> milkFromDripstones;
        public final ForgeConfigSpec.ConfigValue<Boolean> milkingWithGlassBottles;
        public final ForgeConfigSpec.ConfigValue<Boolean> milkshakeCauldrons;
        public final ForgeConfigSpec.ConfigValue<Integer> whiteStrawberryMinHeight;
        public final ForgeConfigSpec.ConfigValue<Boolean> strawberryBushArthropodInvisibility;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpidersFromBundles;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpidersGiveSlipping;
        public final ForgeConfigSpec.ConfigValue<Double> chimpanzeeGroupChance;
        public final ForgeConfigSpec.ConfigValue<Integer> chimpanzeeMaxGroupSize;
        public final ForgeConfigSpec.ConfigValue<Integer> chimpanzeeMinSpawnAttempts;
        public final ForgeConfigSpec.ConfigValue<Integer> chimpanzeeMaxSpawnAttempts;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("items");
            builder.push("milk_bottles");
            this.milkCauldron = builder.comment("If milk can be inserted into cauldrons").define("Milk Cauldron", true);
            this.milkFromDripstones = builder.comment("If cauldrons are filled with milk dropping from a dripstone").define("Milk from Dripstone", true);
            this.milkingWithGlassBottles = builder.comment("If milkable mobs can be milked with empty glass bottles").define("Milking with Glass Bottles", false);
            this.milkshakeCauldrons = builder.comment("If milkshakes can be inserted into cauldrons").define("Milkshake Cauldrons", true);
            builder.pop();
            builder.pop();
            builder.push("blocks");
            builder.push("strawberry_bush");
            this.whiteStrawberryMinHeight = builder.comment("The minimum height required for Strawberry Bushes to grow White Strawberries").define("White Strawberry minimum height", (Object)256);
            this.strawberryBushArthropodInvisibility = builder.comment("If arthropods that go through Strawberry Bushes are given Invisibility").define("Strawberry Bushes give arthropods Invisibility", true);
            builder.pop();
            builder.pop();
            builder.push("mobs");
            builder.push("plantain_spider");
            this.plantainSpidersFromBundles = builder.define("Plantain Spider spawn from Banana Bundles", true);
            this.plantainSpidersGiveSlipping = builder.define("Plantain Spiders give Slipping", true);
            builder.pop();
            builder.push("chimpanzee");
            this.chimpanzeeGroupChance = builder.comment("The percentage chance for a Banana Plant to generate with a group of Chimpanzees").define("Chimpanzee group chance", (Object)0.25);
            this.chimpanzeeMaxGroupSize = builder.comment("The maximum amount of Chimpanzees that can spawn with a Banana Plant").define("Chimpanzee maximum group size", (Object)10);
            this.chimpanzeeMinSpawnAttempts = builder.comment("The minimum attempts for Chimpanzees to spawn with a Banana Plant").define("Chimpanzee minimum spawn attempts", (Object)12);
            this.chimpanzeeMaxSpawnAttempts = builder.comment("The maximum attempts for Chimpanzees to spawn with a Banana Plant").define("Chimpanzee maximum spawn attempts", (Object)24);
            builder.pop();
            builder.pop();
        }
    }
}

