/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.core.data.server.modifiers;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBiomeTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanFeatures;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class NeapolitanBiomeModifierProvider {
    private static final RegistryAccess ACCESS = RegistryAccess.m_206197_();
    private static final Registry<Biome> BIOMES = ACCESS.m_175515_(Registry.f_122885_);
    private static final Registry<PlacedFeature> PLACED_FEATURES = ACCESS.m_175515_(Registry.f_194567_);
    private static final HashMap<ResourceLocation, BiomeModifier> MODIFIERS = new HashMap();

    public static JsonCodecProvider<BiomeModifier> create(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        NeapolitanBiomeModifierProvider.addFeature("strawberry_bush", NeapolitanBiomeTags.HAS_STRAWBERRY_BUSH, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_STRAWBERRY_BUSH);
        NeapolitanBiomeModifierProvider.addFeature("adzuki_sprouts", NeapolitanBiomeTags.HAS_ADZUKI_SPROUTS, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_ADZUKI_SPROUTS);
        NeapolitanBiomeModifierProvider.addFeature("vanilla_vine", NeapolitanBiomeTags.HAS_VANILLA_VINE, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.PATCH_VANILLA_VINE);
        NeapolitanBiomeModifierProvider.addFeature("mint_pond", NeapolitanBiomeTags.HAS_MINT_POND, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.MINT_POND);
        NeapolitanBiomeModifierProvider.addFeature("banana_plant/common", NeapolitanBiomeTags.HAS_COMMON_BANANA_PLANT, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_COMMON);
        NeapolitanBiomeModifierProvider.addFeature("banana_plant/uncommon", NeapolitanBiomeTags.HAS_UNCOMMON_BANANA_PLANT, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_UNCOMMON);
        NeapolitanBiomeModifierProvider.addFeature("banana_plant/rare", NeapolitanBiomeTags.HAS_RARE_BANANA_PLANT, GenerationStep.Decoration.VEGETAL_DECORATION, NeapolitanFeatures.NeapolitanPlacedFeatures.BANANA_PLANT_RARE);
        return JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)existingFileHelper, (String)"neapolitan", (RegistryOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)ACCESS), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, MODIFIERS);
    }

    private static void addModifier(String name, BiomeModifier modifier) {
        MODIFIERS.put(new ResourceLocation("neapolitan", name), modifier);
    }

    @SafeVarargs
    private static void addFeature(String name, TagKey<Biome> biomes, GenerationStep.Decoration step, RegistryObject<PlacedFeature> ... features) {
        NeapolitanBiomeModifierProvider.addModifier("add_feature/" + name, (BiomeModifier)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named(BIOMES, biomes), NeapolitanBiomeModifierProvider.featureSet(features), step));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(RegistryObject<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(registryObject -> PLACED_FEATURES.m_214121_(registryObject.getKey())).collect(Collectors.toList()));
    }
}

